﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Chapter_09
{
    class Program
    {
        static void Main(string[] args)
        {
            Contact myContact = new Contact();
            string address = myContact.FullAddress();

            Contact myContactAsSiteOwner = new SiteOwner();
            address = myContactAsSiteOwner.FullAddress();

            SiteOwner mySiteOwner = new SiteOwner();
            address = mySiteOwner.FullAddress();

            HandleUpdates();
        }

        private static void HandleUpdates()
        {
            // pobierz kontakty
            Contact[] contacts = new Contact[3];
            contacts[0] = new Customer();
            contacts[1] = new SiteOwner();
            contacts[2] = new Contact();

            foreach (var contact in contacts)
            {
                contact.SendAlert();
            }
        }

        private static void HandleUpdatesOld()
        {
            // pobierz kontakty
            Contact[] contacts = new Contact[3];
            contacts[0] = new Customer();
            contacts[1] = new SiteOwner();
            contacts[2] = new Contact();

            foreach (var contact in contacts)
            {
                switch (contact.GetType().ToString())
                {
                    case "Chapter_09.Customer":
                        Customer cust = contact as Customer;
                        cust.SendAlert();
                        break;
                    case "Chapter_09.SiteOwner":
                        SiteOwner owner = contact as SiteOwner;
                        owner.SendAlert();
                        break;
                    case "Chapter_09.Contact":
                        contact.SendAlert();
                        break;
                    default:
                        break;
                }
            }
        }
    }
}
